package org.libspark.flartoolkit.away3d {
	
	import away3d.cameras.Camera3D;
	import away3d.core.base.Vertex;
	import away3d.core.draw.ScreenVertex;
	import away3d.core.math.Matrix3D;
	
	import org.libspark.flartoolkit.core.FLARMat;
	import org.libspark.flartoolkit.core.param.FLARParam;
	import org.libspark.flartoolkit.core.types.FLARIntSize;
	import org.libspark.flartoolkit.utils.ArrayUtil;

	public class FLARCamera3D extends Camera3D {
		
		private static const NEAR_CLIP:Number = 10;
		private static const FAR_CLIP:Number = 10000;

		private var _projectionMatrix:Matrix3D;
		private var _viewportWidth:Number;
		private var _viewportHeight:Number;

		public function FLARCamera3D(param:FLARParam) {
			var m_projection:Array = new Array(16);
			var trans_mat:FLARMat = new FLARMat(3,4);
			var icpara_mat:FLARMat = new FLARMat(3,4);
			var p:Array = ArrayUtil.createJaggedArray(3, 3);
			var q:Array = ArrayUtil.createJaggedArray(4, 4);
			var i:int;
			var j:int;
			const size:FLARIntSize = param.getScreenSize();
			const width:int  = size.w;
			const height:int = size.h;
			
			param.getPerspectiveProjectionMatrix().decompMat(icpara_mat, trans_mat);
			
			var icpara:Array = icpara_mat.getArray();
			var trans:Array = trans_mat.getArray();
			for (i = 0; i < 4; i++) {
				icpara[1][i] = (height - 1) * (icpara[2][i]) - icpara[1][i];
			}
			
			for(i = 0; i < 3; i++) {
				for(j = 0; j < 3; j++) {
					p[i][j] = icpara[i][j] / icpara[2][2];
				}
			}
			q[0][0] = (2.0 * p[0][0] / (width - 1));
			q[0][1] = (2.0 * p[0][1] / (width - 1));
			q[0][2] = -((2.0 * p[0][2] / (width - 1))  - 1.0);
			q[0][3] = 0.0;
			 
			q[1][0] = 0.0;
			q[1][1] = -(2.0 * p[1][1] / (height - 1));
			q[1][2] = -((2.0 * p[1][2] / (height - 1)) - 1.0);
			q[1][3] = 0.0;
			
			q[2][0] = 0.0;
			q[2][1] = 0.0;
			q[2][2] = -(FAR_CLIP + NEAR_CLIP) / (NEAR_CLIP - FAR_CLIP);
			q[2][3] = 2.0 * FAR_CLIP * NEAR_CLIP / (NEAR_CLIP - FAR_CLIP);
			
			q[3][0] = 0.0;
			q[3][1] = 0.0;
			q[3][2] = 1.0;
			q[3][3] = 0.0;
			
			for (i = 0; i < 4; i++) { // Row.
				// First 3 columns of the current row.
				for (j = 0; j < 3; j++) { // Column.
					m_projection[i*4 + j] =
						q[i][0] * trans[0][j] +
						q[i][1] * trans[1][j] +
						q[i][2] * trans[2][j];
				}
				// Fourth column of the current row.
				m_projection[i*4 + 3]=
					q[i][0] * trans[0][3] +
					q[i][1] * trans[1][3] +
					q[i][2] * trans[2][3] +
					q[i][3];
			}
			
			var m:Matrix3D = this._projectionMatrix = new Matrix3D();
			m.sxx =  m_projection[0];
			m.sxy =  -m_projection[1];
			m.sxz =  m_projection[2];
			m.tx  =  m_projection[3];
			m.syx =  m_projection[4];
			m.syy =  -m_projection[5];
			m.syz =  m_projection[6];
			m.ty  =  m_projection[7];
			m.szx =  m_projection[8];
			m.szy =  -m_projection[9];
			m.szz =  m_projection[10];
			m.tz  =  m_projection[11];
			m.swx =  m_projection[12];
			m.swy =  -m_projection[13];
			m.swz =  m_projection[14];
			m.tw  =  m_projection[15];

			this._viewportWidth = width / 2;
			this._viewportHeight = height / 2;
		}

		private var _view:Matrix3D = new Matrix3D();
        public override function get view():Matrix3D {
        	return this._projectionMatrix;
        }
		
		private var m11:Number;
		private var m12:Number;
		private var m13:Number;
		private var m14:Number;
		private var m21:Number;
		private var m22:Number;
		private var m23:Number;
		private var m24:Number;
		private var m31:Number;
		private var m32:Number;
		private var m33:Number;
		private var m34:Number;
		private var m41:Number;
		private var m42:Number;
		private var m43:Number;
		private var m44:Number;
		private var vx:Number;
		private var vy:Number;
		private var vz:Number;
		private var s_x:Number;
		private var s_y:Number;
		private var s_z:Number;
		private var s_w:Number;
		
		// ported from org.papervision3d.cameras.Camera3D#projectVertices
		public override function project(viewTransform:Matrix3D, vertex:Vertex, screenvertex:ScreenVertex):void {
			m11 = viewTransform.sxx;
			m12 = viewTransform.sxy;
			m13 = viewTransform.sxz;
			m14 = viewTransform.tx;
			m21 = viewTransform.syx;
			m22 = viewTransform.syy;
			m23 = viewTransform.syz;
			m24 = viewTransform.ty;
			m31 = viewTransform.szx;
			m32 = viewTransform.szy;
			m33 = viewTransform.szz;
			m34 = viewTransform.tz;
			m41 = viewTransform.swx;
			m42 = viewTransform.swy;
			m43 = viewTransform.swz;
			m44 = viewTransform.tw;
			
			// Center position
			vx = vertex.x;
			vy = vertex.y;
			vz = vertex.z;
			
			s_z = vx * m31 + vy * m32 + vz * m33 + m34;
			s_w = vx * m41 + vy * m42 + vz * m43 + m44;
			s_z /= s_w;
			
			// is point between near- and far-plane?
			if (screenvertex.visible = (s_z > 0 && s_z < 1)) {
				// to normalized clip space (-1,-1) to (1, 1)
				s_x = (vx * m11 + vy * m12 + vz * m13 + m14) / s_w;
				s_y = (vx * m21 + vy * m22 + vz * m23 + m24) / s_w;
				// project to viewport.
				screenvertex.x = s_x * this._viewportWidth;
				screenvertex.y = s_y * this._viewportHeight;
				// NOTE: z not linear, value increases when nearing far-plane.
				screenvertex.z = s_z * s_w;
			}
		}
	}
}